---
  title: Theme Changelog
  subtitle: Lists all changes to the theme files
  layout: docs.hbs
---

# Version 1.0.0
> Release Date : 5th December 2014
- Initial ThemeForest Submit


# Version 1.1.0
> Release Date : 5th December 2014

- **New Demo** Blog site demo content
- **Fix** Issue with zindex on menu below header
- **Fix** Triggering point position for search widget in menu

# Version 1.2.0
> Release Date : 10th December 2014

- **New Demo** Creative site demo content
- **New Feature** Added new portfolio magnific option
- **Fix** Gallery import for Corporate portfolio item
- **Fix** Changed demo import url to use HTTPS

# Version 1.2.1
> Release Date : 18th December 2014

- **New Feature** Added multiple marker option to map shortcode
- **New Feature** Added Panel background colour option
- **WooCommerce** Corrected styling of form-pay.php for Woocommerce
- **Docs** Minified doc images
- **Fix** Issue on older versions of PHP when adding image to post
- **Fix** Issue caused by bug in APC on Goddaddy hosting
- **Fix** Narrow and regular thumbnails for the no-sidebar options
- **Fix** Panel shortcode with visual composer view
- **Fix** Added styling for password protected pages / posts

# Version 1.3.0
> Release Date : 19th December

- **New Demo**Added Restaurant Demo site
- **New Feature** Added hover state on contextual buttons
- **Plugins** Updated Visual Composer to 4.3.5 (Fixes WordPress 4.1 Compatibility)
- **Fix** Issue on light Links on hover
- **Fix** Menu link top border color for transparent menus

# Version 1.4.0
> Release Date : 13th January 2015

- **New Demo** New Hotel demo content
- **New Feature** Styled password protected pages
- **New Feature** Updated pace site loader animation
- **Fix** Divider color on mega menus
- **Fix** Alignment for features list, when no icon is selected
- **Fix** Issue with megamenu on mobiles
- **Fix** Transparent logo on single portfolio page
- **Fix** Submenus when opened in side menu
- **Fix** WPML tranlsation of options


# Version 1.5.0
> Release Date : 28th January 2015

- **New Demo** Magazine
- **Plugins** Updated to Visual Composer 4.4
- **Fix** ScrollTo offset issue on mobile devices
- **JS** Updated Waypoints JS
- **New Feature** Added hide/show post date & author option
- **New Feature** Added text columns option to Text Block shortcode
- **Fix** CSS bug in IE11
- **New Feature** Added Import/Export of the theme options
- **New Feature** Added list style to recent posts shortcode
- **New Feature** New Blog layout options
- **New Feature** New Shortcode - Featured Post
- **New Feature** New Shortcode - Slab Text

# Version 1.5.1
> Release Date : 2nd March 2015

- **PSD** Added new Restaurant and Corporate PSD files
- **Fix** Issue with left image/right image post list bottom borders
- **Fix** Bug for background color of features-list items
- **Fix** Set Slab text minfontsize enabling word wrapping on small screens
- **Fix** Updated 'Video Player' shortcode. It will use 'embed' first and open youtube/vimeo videos in iframe with native html5 'video' fallback for webm/mp4 videos
- **Fix** Issue avatars on comments
- **WooCommerce** Updated woocommerce templates to work with version 2.3.5
- **WooCommerce** Added compatibility with quantity increment plugin https://wordpress.org/plugins/woocommerce-quantity-increment/

# Version 1.5.2
> Release Date : 6th March 2015

- **Fix** Removed unnecessary javascript from theme.min.js and theme.js
- **Fix** Bug in background color of featured icon shortcode
- **Fix** Bug in audio shortcode on iOS
- **PSD** Added new Creative PSD
- **PSD** Added new Magazine PSD

# Version 1.6.0
> Release Date : 16th March 2015

- **New Feature** Number of related products in single product page is now set from number of shop columns.
- **Fix** For cart page button
- **PSD** 4 new PSDs Hotel, Journal, Landing and Shop!
- **Fix** for mobile menus when set to hover
- **Plugins** Updated Revolution Slider to Version 4.6.5

# Version 1.7.0
> Release Date : 19th March 2015

- **New Demo** New charity template added
- **Fix** CSS issues in IE9

# Version 1.8.0
> Release Date : 17th April 2015

- **New Feature** Option to hide author now applies to related posts and masonry blog page.
- **Fix** Post Types now do not inherit custom structure for wordpress permalinks.
- **New Feature** Option to toggle between minified and non-minified assets.
- **Fix** for portfolio overlay zoom buttons, would not work if option to show all magnific images was selected.
- **WooCommerce**Updated woocommerce to 2.3.7
- **Icons** Updated font awesome icon list up to 4.3
- **New Feature**nAdded styling to Gravity forms elements
- **New Feature** Added margin-left and margin-right options to buttons
- **Fix** Issue when woocommerce product table gets updated on checkout
- **Fix** Issue when reset password form for Woocommerce would not send email.
- **New Demo** Coming Soon Demo
- **Fix** Display issue with counters (fonts wobbling)
- **Fix** Made form font sizes relevant to body font size
- **Fix** Made body font sizes relevant to body font size
- **Fix** Removed unused link target option from portfolio masonry shortcode.
- **Fix** Bug where link target option would not work for staff members.
- **Fix** Updated video backgrounds to work with IOS8

# Version 1.8.1
> Release Date : 23rd April 2015

- **New Feature** Added linkable Mega Menu column titles
- **Plugins** Update TGM Pligin to latest version to fix security flaw
- **WooCommerce** Update WooCommerce templates to 2.3.8
- **Fix** Make sure that Mega Menu is installed when user visits 'Menus' in his admin panel
- **Fix** Responsive Logo on menu in mobile view

# Version 1.8.2
> Release Date : 6th May 2015

- **New Feature** Added number of slides option for carousel shortcode.
- **New Feature** Updated Search widget in nav and top bar.
- **New Feature** Portfolio Gallery items now load image captions on magnific popup as title.
- **Fix** Cart page product thumbnails on mobiles.
- **Fix** Maps bug with google latest version.
- **Plugins** Updated visual composer to 4.5
- **Plugins** Updated Revolution Slider to 4.6.92
- **Docs** Updated documentation

# Version 1.8.3
> Release Date : 28th May 2015

- **New Feature** Added product page widget area
- **New Feature** Added justify to all text-align options
- **New Feature** Added option to turn off atom meta
- **New Feature** Icon services are now linkable
- **New Feature** Added option to use custom marker image for Google Maps
- **New Feature** Demo content importer checks for Zip Archive module on server
- **Fix** Magnific popup loads the caption of images as title
- **Fix** Filled in missing font-awesome icons from custom posts lists
- **Fix** Bug for margins of Map shortcode
- **Fix** Google Maps bug related to addresses breaking the map

# Version 1.9.0
> Release Date : 18th June 2015

- **New Demo** Added new Yoga demo site
- **Bootstrap** Updated Bootstrap to 3.3.5
- **New Feature** Magnific videos are now not disabled on mobile
- **New Feature** Improved image uploader option
- **New Feature** Added Page Skin Override Option
- **New Feature** Staff members social icons now load in new tab
- **New Feature** Shop widget now shown on product list pages
- **New Feature** Child theme now contains language translation files
- **Plugins** Updated Visual Composer plugin (4.5.3)
- **Plugins** Updated Envato Toolkit plugin
- **WooCommerce** Updated templates to use latest WooCommerce 2.3.11
- **Fix** Alignment of thumbnails on single page of variable products
- **Fix** For search widget on non-english sites
- **Fix** For woocommerce slideshow numbering

# Version 1.10.0
> Release Date : 8th July 2015

- **New Demo** Wedding Demo Site
- **PSD** Added new Yoga psd file
- **New Feature** Media galleries now load captions, if set
- **Fix** Transparent logo option fixed on blog pages
- **Plugins** Updated Revolution Slider to 4.6.93

# Version 1.11.0
> Release Date : 20th July 2015

- **New Demo** Photography demo site
- **PSD** Photography PSD
- **Plugins** Updated Visual Composer to 4.6.0
- **WooCommerce** Compatible with latest Woocommerce 2.3.13
- **Fix** Accordion throwing notice when state not defined
- **Fix** Color of magnific popup captions
- **Fix** Extra CSS now loads after skin CSS file
- **Docs** Improved Docs

# Version 1.11.1
> Release Date : 24th July 2015

- **Fix** Blog page on menu stays active on all blog pages
- **Fix** Masonry layout bug on recent posts
- **Fix** Default numeric values for shortcode options

# Version 1.12.0
> Release Date : 29th July 2015

- **New Demo** Medical demo site
- **New Feature** Added modals
- **New Feature** Added modal open options to buttons and menu
- **New Feature** Improved server error checking when updating Google fonts
- **New Feature** Improved server error checking before one click installer starts

# Version 1.13.0
> Release Date : 4th August 2015

- **New Demo** Digital Agency Demo
- **Fix** Order button on checkout not always clickable.
- **Plugins** Updated Visual Composer to 4.6.2
- **Icons** Updated Font Awesome icons to 4.4

# Version 1.14.0
> Release Date : 10th August 2015

- **New Demo** Pets
- **New Demo** Construction
- **New Feature** Added new construction and digital agency PSD files
- **New Feature** Added check for staff with no featured image
- **Fix** Removed sidebar when Shop layout is set to fullwidth

# Version 1.14.1
> Release Date : 28th August 2015

- **New Feature** Enabled Site Overrides options for services and staff post types.
- **New Feature**Integrated new site icon option of customizer into the theme.
- **WooCommerce** Added support for Woocommerce 2.4.5
- **WooCommerce** Styled Woocommerce's Store Notice text.
- **New Feature** Added VK social sharing option.
- **New Feature** Enabled breadcrumbs for pages.
- **Fix** Wrong options loaded for VC columns and heading shortcode.
- **Fix** Bug for icon shortcode.
- **Fix** Chart shortcode bug
- **Fix** Bug for menu not showing up in customizer in WP 4.3
- **Fix** For decoding slugs in categories in portfolio filters.

# Version 1.15.0
> Release Date : 23rd September 2015

- **New Demo** Education
- **New Demo** Travel Agency
- **New Feature** Added image parameter on facebook sharing links. Uses featured image.
- **WooCommerce** Woocommerce 2.4.6 ready.
- **Plugins** Updated Visual Composer to 4.7.2
- **Plugins** Updated Revolution Slider to 5.0.9
- **Fix** CSS Fix for mobile comments
- **Fix** Social icons now appear on Staff Members without photo
- **Docs** Added optimization guide to docs
- **Docs** Improved Docs

# Version 1.15.1
> Release Date : 9th October 2015

- **Fix** Accordion - side menu conflict
- **Fix** Pricing shortcode bug
- **Plugins** Updated Visual Composer to 4.7.4

# Version 1.16.0
> Release Date : 26th October 2015

- **New Demo** Law Company
- **New Demo** Political
- **New Demo** Barber Shop
- **Plugins** Updated Visual Composer to 4.8
- **Fix** Issue with wpml menu language widget
- **Fix** Theme to work with Contact Form 7 Datepicker Version 2.4.5

# Version 1.17.0
> Release Date : 18th November 2015

- **New Demo** Architecture
- **New Demo** Dance School
- **New Demo** Winery
- **WooCommerce** Updated woocommerce templates
- **Fix** Fade in animations of FireFox
- **Fix** Option for controls alignment on single product slider.
- **Fix** Single service image links and excerpt alignment.
- **New Feature** Added Extra Javascript option that loads last on the head of the DOM.

# Version 1.18.0
> Release Date : 14th January 2015

- **New Demo** Gym
- **New Demo** Single Product
- **New Demo**Recipies
- **WordPress** Added responsive image support for Wordpress 4.4
- **WooCommerce** Updated Woocommerce to 2.4.12
- **New Feature** Improved Gallery shortcode to navigate through images on popup
- **Plugins** Updated Visual Composer 4.9.2
- **Plugins** Updated Revolution Slider to 5.1.6
- **Fix** Broken url for Link post type in Recent Posts widget

# Version 1.19.0
> Release Date : 17th March 2016

**Warning  will need to update to Woocommerce 2.5.5**

- **WooCommerce** Updated Woocommerce templates to 2.5.5
- **Plugins** Updated Revolution Slider to 5.2.3
- **Plugins** Updated Visual Composer to 4.11.1
- **Fix** Bug in visual composer setup (was breaking some older versions)
- **Fix** Link target option for buttons
- **Fix** Markup error on pagination links
- **Fix** Figure elements for list containers (staff members etc)
- **Docs** Added detailed descriptions on skin options

# Version 1.19.1
> Release Date : 13th April 2016

- **WordPress** Compatible with Wordpress 4.5
- **Fix** Option to disable related posts section now works on Lambda -> Blog
- **Fix** For cross-sales products in woocommerce cart page.
- **Plugins** Updated Visual Composer to 4.11.2 (fixes WordPress 4.5 bug)

# Version 1.20.0
> Release Date : 21st April 2016

- **New Demo** Church Demo
- **New Feature** Front editor for Visual Composer
- **New Feature** Added responsive options for columns
- **New Feature** Added responsive options for shop columns
- **New Feature** Image shortcode now has size option
- **New Feature** Portfolio masonry can now load popup images as a gallery
- **New Feature** Added new loader styles: logo and logo 3d
- **New Feature** Added Polish translation
- **New Feature** Added CSS style for Sermon Manager Plugin
- **Docs** Documentation now has a search feature
- **One Click** One Click Installer now sets up Contact Forms
- **Fix** focus state on buttons and links
- **Plugins** Added Envato Market plugin for updates

# Version 1.21.0
> Release Date : 5th May 2016

- **New Demo** Gadget Shop
- **New Feature** Added New Menu shortcode.
- **New Feature**  Added column options for masonry portfolio.
- **New Feature** Added option for sticky menu on mobile devices.
- **New Feature** Added native language name option for WPML language selector widget.
- **New Feature** Menu items can now be icons.
- **Fix**  Portfolio popup gallery loads the filtered items, if filters are enabled.
- **Fix** Bug where Facebook sharer would fail.

# Version 1.21.1
> Release Date : 12th May 2016

- **New Feature** New Header option Fixed Side Menu Left / Right
- **Fix** Bug for Visual Composer on posts
- **Plugins** Updated Revolution Slider to 5.2.5.1

# Version 1.22.0
> Release Date : 19th May 2016

- **New Demo** Photo Studio
- **Icons** Updated Font Awesome icons to 4.6.2
- **New Feature** Added dropdown option to WPML widget
- **New Feature** New option for capitalized breadcrumbs

# Version 1.23.0
> Release Date : 30th May 2016

- **New Demo** Hosting Company
- **New Feature** Added option to hide footer per page
- **New Feature** Added option to enable Back to Top button for mobile devices
- **New Feature** Added fixed height option to Testimonials shortcode
- **New Feature** New shortcode Animated Headlines
- **Plugins** Updated TGM Plugin to latest version (2.6.1)

# Version 1.23.1
> Release Date : 14th June 2016

- **Plugins** Updated Visual Composer to 4.12
- **Plugins** Updated Revolution Slider to 5.2.5.3
- **Plugins** Switched update plugin to Envato Market plugin
- **Docs** Updated docs with new update procedure.
- **Fix** Bug in loading stack files on windows server

# Version 1.24.0
> Release Date : 24th June 2016

- **New Demo** content Curriculum Vitae
- **Fix** Breadcrumbs for month archive link
- **One Click** Demo content installer now sets site background image
- **Plugins** Updated Revolution Slider to 5.2.5.4

# Version 1.24.1
> Release Date : 4th July 2016

**Warning -  will need to update to Woocommerce 2.6.1**

- **WooCommerce** Updated woocommerce to 2.6.1
- **New Feature** Added Google API key option for new Google Javascript API policy. Needed for new websites that use Google maps or other Javascript API applications.
- **Plugins** Updated Revolution Slider to 5.2.6

# Version 1.25.0
> Release Date : 11th July 2016

- **New Demo** Startup Company Demo
- **New Feature** Added support for RTL languages
- **New Feature** Added Timeline shortcode
- **New Feature** Added custom image size option to Image shortcode
- **Fix** Minor styling issue on product category thumbnails

# Version 1.26.0
> Release Date : 18th July 2016

- **New Demo** Performing Art Demo
- **Fix** One page menu for windows mobile
- **Fix** 5 column layout in Visual Composer Frontend Editor

# Version 1.27.0
> Release Date : 2nd August 2016

- **New Demo** Fashion Magazine demo
- **New Feature** Added compatibility with Nav Menu Roles plugin
- **Fix** Default values for column layouts on tablets, mobiles & Large Screens

# Version 1.28.0
> Release Date : 9th August 2016

- **New Demo** Brewery Shop Demo
- **WooCommerce** Updated WooCommerce to v2.6.4

# Version 1.29.0
> Release Date : 19th August 2016

- **New Demo** Tattoo Parlour Demo

# Version 1.30.0
> Release Date : 23rd August 2016

- **New Demo** Organic Shop Demo
- **Fix** Scrolling to #id section when navigating from another page

# Version 1.31.0
> Release Date : 5th September 2016

- **New Demo** Music Band Demo
- **Docs** Updated Documentation

# Version 1.32.0
> Release Date : 12th September 2016

- **New Demo** Logistics
- **Plugins** Updated visual composer to 4.12.1

# Version 1.33.0
> Release Date : 12th September 2016

- **New Demo** Martial Arts

# Version 1.34.0
> Release Date : 26th September 2016

- **New Demo** Handyman

# Version 1.35.0
> Release Date : 3rd October 2016

- **New Demo** Cafe

# Version 1.36.0
> Release Date : 11th October 2016

- **New Demo** Product Launch
- **New Feature** Added option to remove link from blog list featured images
- **New Feature** Added Gallery shortcode

# Version 1.37.0
> Release Date : 17th October 2016

- **New Demo** Spa & Beauty

# Version 1.38.0
> Release Date : 24th October 2016

- **New Demo** Gardening

# Version 1.39.0
> Release Date : 2nd November 2016

- **New Demo** Pizza Restaurant
- **Fix** 404 page to user translation page using wpml
- **Fix** Missing theme-rtl.min.css file

# Version 1.40.0
> Release Date : 7th November 2016

- **New Demo** Senior Care Homer
- **Plugins** Updated Revolution Slider Version 5.3

# Version 1.41.0
> Release Date : 14th November 2016

- **New Demo** Consultant Business
- **Plugins** Updated Visual Composer Version 5.0
- **Fix** Changed stack code to load stack CSS using wp_enqueue_style (allows override in child theme)

# Version 1.42.0
> Release Date : 22nd November 2016

- **New Demo** Extreme Sports
- **Fix** Removed TGM plugin nag message.

# Version 1.43.0
> Release Date : 28th November 2016

- **New Demo** Awards Site

# Version 1.44.0
> Release Date : 5th December 2016

- **New Demo** Horseriding Site

# Version 1.45.0
> Release Date : 19th December 2016

- **New Demo** Aquarium
- **Plugins** Updated Revolution Slider to v5.3.1.5
- **Plugins** Updated Visual Composer to v5.0.1
- **Fix** Ajax loader in Contact Form 7

# Version 1.45.1
> Release Date : 20th December 2016

- **WooCommerce** Fix woocommerce checkout with stripe gateway plugin.
- **WooCommerce** Updated Woocommerce to v2.6.9

# Version 1.46.0
> Release Date : 3rd January 2017

- **New Demo** Business RTL
- **Maps** Updated Google Maps API version

# Version 1.46.1
> Release Date : 10th January 2017

- **Plugins** Added Grid builder of Visual Composer
- **Plugins** Added Visual Composer Button Shortcode (used in grid builder)
- **Fix** Fixed minor issue in PHP 7 with column calculations
- **Documentation** Updated documentation

# Version 1.47.0
> Release Date : 23rd January 2017

- **New Demo** Hipster Fashion Shop
- **i18n** Better coverage of translation functions in pot files

# Version 1.48.0
> Release Date : 31st January 2017

- **New Demo** App Landing Page

# Version 1.49.0
> Release Date : 13th February 2017

- **New Demo** Gamer Blog
- **Fix** Fixed wrong Indentation on multiple dropdown menus on mobile

# Version 1.50.0
> Release Date : 14th March 2017

- **New Demo** Taxi Service
- **Icons** Updated Font Awesome icons to v4.7
- **WooCommerce** Compatible with Woocommerce 2.6.14

# Version 1.51.0
> Release Date : 4th April 2017

- **New Demo** Doctors Surgery
- **Fix** Menu notice no longer shows.

# Version 1.52.0
> Release Date : 18th April 2017

**WARNING - This is a major update to WooCommerce please test before updating**

- **New Demo** Tourist Destination
- **WooCommerce** Updated templates to be compatible with WooCommerce 3.0.3

# Version 1.52.1
> Release Date : 27th April 2017

- **Plugins** Updated Visual Composer to v5.1.1
- **Fix** For phone and email fields on Woocommerce not being editable
- **Fix** For RTL languages on Woocommerce single product pages
- **Fix** For shop page rendering sidebar at the bottom

# Version 1.53.0
> Release Date : 29th May 2017

- **New Demo** E-Learning
- **Plugins** Updated Revolution Slider plugin to v5.4.3.1
- **WooCommerce** Woocommerce sitewide store message is now dismissible.
- **WooCommerce** Compatible with Woocommerce 3.0.7
- **Fix** Product categories and tags options
- **Fix** Fixed bug for 404 page when custom permalinks are set.

# Version 1.53.1
> Release Date : 21st July 2017

- **Plugins** Updated Visual Composer to v5.2
- **Plugins** Updated Revolution Slider plugin to v5.4.5.1
- **WooCommerce** Compatible with Woocommerce v3.1.1
- **WooCommerce** Cart widget on menu now takes you to the Cart page when clicked, if menu is set to work on hover.
- **WooCommerce** Woocommerce translations fixed.
- **Fix** Fixed sticky menu offset on mobiles.
- **Maps** Updated Google Maps API to the latest release version.

# Version 1.53.2
> Release Date : 25th September 2017

- **New Feature** Added featured image option as source for the Image shortcode.
- **Plugins** Updated Visual Composer to v5.3
- **Plugins** Updated Revolution Slider plugin to v5.4.6
- **WooCommerce** Compatible with Woocommerce v3.1.2
- **Fix** Fixed subfooter skin colors

# Version 1.53.3
> Release Date : 13th November 2017

- **Plugins** Updated Visual Composer to v5.4.2
- **WooCommerce** Compatible with Woocommerce v3.2.3
- **Maps** Updated Google Maps API version
- **Fix** Fixed bug that broke read more link on posts when carousel shortcode was used

# Version 1.54.0
> Release Date : 17th November 2017

- **New Demo** Landing Modern
- **WordPress** Compatible with WordPress v4.9
- **Plugins** Updated Visual Composer to v5.4.4
- **Plugins** Updated Revolution Slider plugin to v5.4.6.3.1
- **WooCommerce** Improved compatibility of Woocommerce plugin with PHP 7
- **Fix** Background videos for WordPress v4.9
- **Fix** Stack error caused by latest Visual Composer plugin

# Version 1.55.0
> Release Date : 27th November 2017

- **New Demo** Software Landing Page - SaaS
- **Plugins** Updated Visual Composer to v5.4.5

# Version 1.55.1
> Release Date : 28th November 2017

- **Fix** Missing One Click Installer Demo (Sass)
